/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHPublicKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.util.Objects;
import javax.crypto.spec.DHParameterSpec;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

final class DHPrivateKey
implements PrivateKey,
javax.crypto.interfaces.DHPrivateKey,
Serializable {
    static final long serialVersionUID = 7565477590005668886L;
    private static final BigInteger PKCS8_VERSION = BigInteger.ZERO;
    private BigInteger x;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};

    DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n) {
        this.x = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n;
        try {
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new ProviderException("Cannot produce ASN.1 encoding", iOException);
        }
    }

    DHPrivateKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue(byteArrayInputStream);
            if (derValue.tag != 48) {
                throw new InvalidKeyException("Key not a SEQUENCE");
            }
            BigInteger bigInteger = derValue.data.getBigInteger();
            if (!bigInteger.equals(PKCS8_VERSION)) {
                throw new IOException("version mismatch: (supported: " + PKCS8_VERSION + ", parsed: " + bigInteger);
            }
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.tag != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (objectIdentifier == null) {
                throw new InvalidKeyException("Null OID");
            }
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException("Parameters missing");
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.tag == 5) {
                throw new InvalidKeyException("Null parameters");
            }
            if (derValue3.tag != 48) {
                throw new InvalidKeyException("Parameters not a SEQUENCE");
            }
            derValue3.data.reset();
            this.p = derValue3.data.getBigInteger();
            this.g = derValue3.data.getBigInteger();
            if (derValue3.data.available() != 0) {
                this.l = derValue3.data.getInteger();
            }
            if (derValue3.data.available() != 0) {
                throw new InvalidKeyException("Extra parameter data");
            }
            this.key = derValue.data.getOctetString();
            this.parseKeyBits();
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (IOException | NumberFormatException exception) {
            throw new InvalidKeyException("Error parsing key encoding", exception);
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    @Override
    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putInteger(PKCS8_VERSION);
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(DHPublicKey.DH_OID);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putInteger(this.p);
                derOutputStream3.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream3.putInteger(this.l);
                }
                DerValue derValue = new DerValue(48, derOutputStream3.toByteArray());
                derOutputStream2.putDerValue(derValue);
                derOutputStream.write((byte)48, derOutputStream2);
                derOutputStream.putOctetString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    @Override
    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    private void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.x = derInputStream.getBigInteger();
        }
        catch (IOException iOException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException("Error parsing key encoding: " + iOException.getMessage());
            invalidKeyException.initCause(iOException);
            throw invalidKeyException;
        }
    }

    public int hashCode() {
        return Objects.hash(this.x, this.p, this.g);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof javax.crypto.interfaces.DHPrivateKey)) {
            return false;
        }
        javax.crypto.interfaces.DHPrivateKey dHPrivateKey = (javax.crypto.interfaces.DHPrivateKey)object;
        DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
        return this.x.compareTo(dHPrivateKey.getX()) == 0 && this.p.compareTo(dHParameterSpec.getP()) == 0 && this.g.compareTo(dHParameterSpec.getG()) == 0;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }
}

